﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Security.Principal;
using System.Text;
using System.Windows.Forms;
using Winfoot_7.Class;
using Winfoot_7.Controller;

namespace Winfoot_7
{
    public partial class Form1 : Form
    {

        private ControllerManager controllermanager = new ControllerManager();

        public Form1()
        {
            InitializeComponent();
        }

        private bool IsAdmin()
        {
            WindowsIdentity usrId = WindowsIdentity.GetCurrent();
            WindowsPrincipal p = new WindowsPrincipal(usrId);
            return p.IsInRole(@"BUILTIN\Administrators");
        }


        private void RestartApplication()
        {
            ProcessStartInfo startInfo = new ProcessStartInfo();
            startInfo.UseShellExecute = true;
            startInfo.WorkingDirectory = Environment.CurrentDirectory;
            startInfo.FileName = Application.ExecutablePath;
            startInfo.Verb = "runas";

            try
            {
                Process p = Process.Start(startInfo);
            }
            catch
            {
                return;
            }
            Application.Exit();
            
        }


        private void Form1_Load(object sender, EventArgs e)
        {

#if DEBUG
            //デバッグ時は管理者として起動しない
            //VisualStudioで管理者としてDebugテストしたい場合は、VSを管理者として起動すべし
#else
            if (!IsAdmin() && Environment.OSVersion.Version.Major >= 6)
            {
                RestartApplication();
            }
#endif

            controllermanager.MenuController = new MenuController(menu1);
            controllermanager.PluginController = new PluginController();
            List<IMenuItem> RootItems = new List<IMenuItem>
                                        {
                                                           new WinfootMenuItem(Properties.Resources.cnr,"パフォーマンス",new ArticleReadStratety(controllermanager,@"./Plugin/Performance",splitContainer1.Panel2)),
                                                           new WinfootMenuItem(Properties.Resources.display,"システム",new ArticleReadStratety(controllermanager,@"./Plugin/System",splitContainer1.Panel2)),
                                                           new WinfootMenuItem(Properties.Resources.ksysguard,"セキュリティ",new ArticleReadStratety(controllermanager,@"./Plugin/Security",splitContainer1.Panel2)),
                                                           new WinfootMenuItem(Properties.Resources.linneighborhood,"ネットワーク",new ArticleReadStratety(controllermanager,@"./Plugin/Network",splitContainer1.Panel2)),
                                                           new WinfootMenuItem(Properties.Resources.utilities,"Ohters",new ArticleReadStratety(controllermanager,@"./Plugin/Others",splitContainer1.Panel2)),
                                                           new WinfootMenuItem(Properties.Resources.agt_action_success,"適用",new ApplyStrategy(controllermanager)),
                                                           new WinfootMenuItem(Properties.Resources.filesaveas,"バックアップ",new BackUpStrategy(controllermanager.PluginController)),
                                                           new WinfootMenuItem(Properties.Resources.revert,"復元",new RestorationStrategy()),
                                                       };

            //メニューのセット
            controllermanager.MenuController.RootMenu = RootItems;
            controllermanager.MenuController.SetMenuItems(RootItems);
        }

        private void menu1_ItemClick(object sender, WinfootMenuItem menuItem)
        {
            menuItem.Pushed();
        }

        public void ShowRootMenu()//暫定処置 消える可能性あり
        {
            controllermanager.MenuController.ReturnToRoot();
        }
    }
}
